<?php

// add some custom js to the head of the page
function add_custom_scripts() {
	global $custom_meta_fields,$custom_page_meta_fields, $post;
	if(!isset($_GET["page"])&& !isset($_GET['type'])){
		wp_enqueue_script('jquery-ui-datepicker');
		wp_enqueue_script('jquery-ui-slider');
		wp_enqueue_script('custom-js', get_template_directory_uri() . '/functions/page_options/page-options.js');
		wp_enqueue_script('custom-js-page', get_template_directory_uri() . '/functions/page_options/page-options-custom.js');
		//wp_enqueue_style('jquery-ui-custom', get_template_directory_uri() .'/functions/template/admin/adminpanel/css/jquery-ui-custom.css');
	}
}

add_action('admin_enqueue_scripts','add_custom_scripts');

// The Callback
function show_custom_meta_box() {
	global $custom_meta_fields,$post;
	// Use nonce for verification
	echo '<input type="hidden" name="custom_meta_box_nonce" value="'.wp_create_nonce(basename(__FILE__)).'" />';
	
	// Begin the field table and loop
	echo '<table class="form-table">';
	foreach ($custom_meta_fields as $field) {
		// get value of this field if it exists for this post
		$meta = get_post_meta($post->ID, $field['id'], true);
		if(!isset($field['class'])) $field['class']="";
		if(!isset($field['label'])) $field['label']="";
		if(!isset($field['type'])) $field['type']="";
		// begin a table row with
		echo '<tr class="'.$field['class'].'">
				<th><label for="'.$field['id'].'">'.$field['label'].'</label></th>
				';
				switch($field['type']) {
					//description
					case 'desc':
						echo '<td colspan=2><span class="description">'.$field['desc'].'</span></td>';
					break;
					// text
					case 'text':
						echo '<td><input type="text" name="'.$field['id'].'" id="'.$field['id'].'" value="'.$meta.'" size="30" /></td>
								<td width="30%"><span class="description">'.$field['desc'].'</span></td>';
					break;
					// textarea
					case 'textarea':
						echo '<td><textarea name="'.$field['id'].'" id="'.$field['id'].'" cols="40" rows="4">'.$meta.'</textarea></td>
								<td><span class="description">'.$field['desc'].'</span></td>';
					break;
					// checkbox
					case 'checkbox':
						echo '<td><input type="checkbox" name="'.$field['id'].'" id="'.$field['id'].'" ',$meta ? ' checked="checked"' : '','/>
								<label for="'.$field['id'].'">'.$field['text'].'</label>
								</td><td><span class="description">'.$field['desc'].'</span></td>';
					break;
					// select
					case 'select':
						echo '<td><select name="'.$field['id'].'" id="'.$field['id'].'">';
						foreach ($field['options'] as $option) {
							echo '<option', $meta == $option['value'] ? ' selected="selected"' : '', ' value="'.$option['value'].'">'.$option['label'].'</option>';
						}
						echo '</select>
							</td><td><span class="description">'.$field['desc'].'</span></td>';
					break;
					// radio
					case 'radio':
						echo '<td>';
						foreach ( $field['options'] as $option ) {
							if ($meta=="") $meta=$field['default'];
							echo '<input type="radio" name="'.$field['id'].'" id="'.$field['id']."_".$option['value'].'" value="'.$option['value'].'" ',$meta == $option['value'] ? ' checked="checked"' : '',' />
									<label for="'.$option['value'].'">'.$option['label'].'</label><br />';
						}
						echo '</td><td><span class="description">'.$field['desc'].'</span></td>';
					break;
					// checkbox_group
					case 'checkbox_group':
						foreach ($field['options'] as $option) {
							echo '<td><input type="checkbox" value="'.$option['value'].'" name="'.$field['id'].'[]" id="'.$option['value'].'"',$meta && in_array($option['value'], $meta) ? ' checked="checked"' : '',' /> 
									<label for="'.$option['value'].'">'.$option['label'].'</label><br />';
						}
						echo '</td><td><span class="description">'.$field['desc'].'</span></td>';
					break;
					// tax_select
					case 'tax_select':
						echo '<td><select name="'.$field['id'].'" id="'.$field['id'].'">
								<option value="">Select One</option>'; // Select One
						$terms = get_terms($field['id'], 'get=all');
						$selected = wp_get_object_terms($post->ID, $field['id']);
						foreach ($terms as $term) {
							if (!empty($selected) && !strcmp($term->slug, $selected[0]->slug)) 
								echo '<option value="'.$term->slug.'" selected="selected">'.$term->name.'</option>'; 
							else
								echo '<option value="'.$term->slug.'">'.$term->name.'</option>'; 
						}
						$taxonomy = get_taxonomy($field['id']);
						echo '</select></td>
						<td><span class="description"><a href="'.get_bloginfo('home').'/wp-admin/edit-tags.php?taxonomy='.$field['id'].'">Manage '.$taxonomy->label.'</a></span></td>';
					break;
					// post_list
					case 'post_list':
					$items = get_posts( array (
						'post_type'	=> $field['post_type'],
						'posts_per_page' => -1
					));
						echo '<td><select name="'.$field['id'].'" id="'.$field['id'].'">
								<option value="">Select One</option>'; // Select One
							foreach($items as $item) {
								echo '<option value="'.$item->ID.'"',$meta == $item->ID ? ' selected="selected"' : '','>'.$item->post_type.': '.$item->post_title.'</option>';
							} // end foreach
						echo '</select></td>
							<td><span class="description">'.$field['desc'].'</span></td>';
					break;
					// unlimited sidebars
					case 'sidebar_list':
						global $wp_registered_sidebars;
					    if( empty( $wp_registered_sidebars ) )
					        return;
					    $name = $field['id'];
					    $current = ( $meta ) ? esc_attr( $meta ) : false;     
					    $selected = '';
					    echo "<td><select name='$name'>";
					    foreach( $wp_registered_sidebars as $sidebar ) : 
					        if( $current ) 
					            if($sidebar['name'] == $current)
					            	$selected = "selected";
					            else 
					            	$selected = "";
					        echo "<option value='".$sidebar['name']."' $selected>";
					        echo $sidebar['name'];
					    	echo "</option>";
					    endforeach;
					    echo "</select></td>";
						echo '<td><span class="description">'.$field['desc'].'</span></td>';
					break;  
					case 'slider_list':
						echo '<td><select name="'.$field['id'].'" id="'.$field['id'].'">';
                		$slider_slugs = get_option("alterego_sliders");
                		$slider_counter = 0;
            			foreach ( $slider_slugs as $slug ){
                			$checked="";
                		 	if($slug==$meta) $checked="selected";
                		 	echo "<option value='$slug' $checked>".get_option($slug."banner_slug")."</option>";
                		} 
                		echo '</select>';
					break;
					// unlimited portfolios
					case 'portfolio_list':
						echo '<td><select name="'.$field['id'].'" id="'.$field['id'].'">';
                		$portfolio_slugs = get_option("alterego_portfolio_slug");
                		$portfolio_counter = 0;
                		$portfolio_name = get_option("alterego_portfolio_name");
	                		foreach ( $portfolio_slugs as $slug ){
	                			$checked="";
	                		 	if($slug==$meta) $checked="selected";
	                		 	echo "<option value='$slug' $checked>".$portfolio_name[$portfolio_counter++]."</option>";
	                		} 
                		echo '</select>';
					break;
					// date
					case 'date':
						echo '<td><input type="text" class="datepicker" name="'.$field['id'].'" id="'.$field['id'].'" value="'.$meta.'" size="30" /></td>
								<td><span class="description">'.$field['desc'].'</span></td>';
					break;
					// slider
					case 'slider':
					$value = $meta != '' ? $meta : '0';
						echo '<td><div id="'.$field['id'].'-slider"></div>
								<input type="text" name="'.$field['id'].'" id="'.$field['id'].'" value="'.$value.'" size="5" /></td>
								<td><span class="description">'.$field['desc'].'</span></td>
								<script>
								jQuery(function() {
									jQuery( "#'.$field['id'].'-slider" ).slider({
										range: "max",
										min: 1,
										max: 10,
										value: '.$meta.',
										slide: function( event, ui ) {
											jQuery( "#'.$field['id'].'" ).val( ui.value );
										}
									});
									jQuery( "#'.$field['id'].'" ).val( jQuery( "#'.$field['id'].'-slider" ).slider( "value" ) );
								});
								</script>
								';
					break;
					// image
					case 'image':
						$image = get_template_directory_uri().'/images/assets/bg/tiled1.jpg';	
						echo '<span class="custom_default_image" style="display:none">'.$image.'</span>';
						if ($meta) { $image = wp_get_attachment_image_src($meta, 'medium');	$image = $image[0]; }				
						echo	'<td style="max-width:100%"><input name="'.$field['id'].'" type="hidden" class="custom_upload_image" value="'.$meta.'" />
										<img src="'.$image.'" class="custom_preview_image" style="width:100%" alt="" /><br />
										<input class="custom_upload_image_button button" type="button" value="Choose Image" />
										<small>&nbsp;<a href="#" class="custom_clear_image_button">Remove Image</a></small>
										<br clear="all" /></td>
										<td><span class="description">'.$field['desc'].'</span></td>';
					break;
					// repeatable
					case 'repeatable_taglines':
						$meta_body = get_post_meta($post->ID, $field['id'], true);
						echo '<td><a class="repeatable-add button" href="#">Add another Tagline</a>
								<ul id="'.$field['id'].'-repeatable" class="custom_repeatable">';
						$i = 0;
						if (is_array($meta_body)) {
							foreach($meta_body as $row) {
							echo '<li class="widget ui-draggable"><div class="widget-top sort hndle" style="cursor:move; height:30px;margin-bottom:2px;"><span style="line-height:30px;margin-left:10px;">|||</span><a class="repeatable-remove button" style="float:right;margin-top:3px;margin-right:10px;" href="#">Remove</a></div>
										<div style="padding:10px;">
											
											<textarea name="'.$field['id'].'[]" id="'.$field['id'].'_body_'.$i.'" rows=8 style="width: 100%;">'.$meta_body[$i].'</textarea>
										</div>
									</li>';
							$i++;
							}
						} else {
							echo '<li class="widget ui-draggable"><div class="widget-top sort hndle" style="cursor:move; height:30px;margin-bottom:2px;"><span style="line-height:30px;margin-left:10px;">|||</span><a class="repeatable-remove button" style="float:right;margin-top:3px;margin-right:10px;" href="#">Remove</a></div>
										<div style="padding:10px;">
											
											<textarea name="'.$field['id'].'[]" id="'.$field['id'].'_body_'.$i.'" rows=8 style="width: 100%;"></textarea>
										</div>
									</li>';
						}
						echo '</ul></td>
							<td><span class="description">'.$field['desc'].'</span></td>';
					break;

					case 'repeatable_images':
						$meta_body = get_post_meta($post->ID, $field['id'], true);
						echo '<td><a class="repeatable-add-image button" href="#">Add another Pic</a>
								<ul id="'.$field['id'].'-repeatable" class="custom_repeatable">';
						$i = 0;
						if (is_array($meta_body)) {
							foreach($meta_body as $meta) {
							if ($meta) { $image = wp_get_attachment_image_src($meta, 'medium');	$image = $image[0]; }
							else $image = "";

							echo '<li class="widget ui-draggable"><div class="widget-top sort hndle" style="cursor:move; height:30px;margin-bottom:2px;"><span style="line-height:30px;margin-left:10px;">|||</span><a class="repeatable-remove button" style="float:right;margin-top:3px;margin-right:10px;" href="#">Remove</a></div>
										<div style="padding:10px;">
											<span class="custom_default_image" style="display:none">'.$image.'</span>
											<input name="'.$field['id'].'[]" type="hidden" class="custom_upload_image" value="'.$meta.'" />
													<img src="'.$image.'" class="custom_preview_image" alt="" /><br />
														<input class="custom_upload_image_button button" type="button" value="Choose Image" />
														<small>&nbsp;<a href="#" class="custom_clear_image_button">Remove Image</a></small>
														<br clear="all" />
											</div>
								</li>';
							$i++;
							}
						} else {
							echo '<li class="widget ui-draggable"><div class="widget-top sort hndle" style="cursor:move; height:30px;margin-bottom:2px;"><span style="line-height:30px;margin-left:10px;">|||</span><a class="repeatable-remove button" style="float:right;margin-top:3px;margin-right:10px;" href="#">Remove</a></div>
										<div style="padding:10px;">
											<span class="custom_default_image" style="display:none"></span>
											<input name="'.$field['id'].'[]" type="hidden" class="custom_upload_image" value="" />
													<img src="" class="custom_preview_image" alt="" /><br />
														<input class="custom_upload_image_button button" type="button" value="Choose Image" />
														<small>&nbsp;<a href="#" class="custom_clear_image_button">Remove Image</a></small>
														<br clear="all" />
											
										</div>
									</li>';
						}
						echo '</ul></td>
							<td><span class="description">'.$field['desc'].'</span></td>';
					break;

					case 'repeatable_partners':
						$meta_body = get_post_meta($post->ID, $field['id'], true);
						$meta_link = get_post_meta($post->ID, $field['id']."_link", true);
						echo '<td><a class="repeatable-add-image button" href="#">Add another Pic</a>
								<ul id="'.$field['id'].'-repeatable" class="custom_repeatable">';
						$i = 0;
						if (is_array($meta_body)) {
							foreach($meta_body as $meta) {
							if ($meta) { $image = wp_get_attachment_image_src($meta, 'medium');	$image = $image[0]; }
							else $image = "";

							echo '<li class="widget ui-draggable"><div class="widget-top sort hndle" style="cursor:move; height:30px;margin-bottom:2px;"><span style="line-height:30px;margin-left:10px;">|||</span><a class="repeatable-remove button" style="float:right;margin-top:3px;margin-right:10px;" href="#">Remove</a></div>
										<div style="padding:10px;">
											<span class="custom_default_image" style="display:none">'.$image.'</span>
											<input name="'.$field['id'].'[]" type="hidden" class="custom_upload_image" value="'.$meta.'" />
													<img src="'.$image.'" class="custom_preview_image" alt="" /><br />
														<input class="custom_upload_image_button button" type="button" value="Choose Image" />
														<small>&nbsp;<a href="#" class="custom_clear_image_button">Remove Image</a></small>
														<br clear="all" /><br>
														Partner URL<br>
														<input class="widefat" style="width:80%" name="'.$field['id'].'_link[]" value="'.$meta_link[$i].'">
											</div>
								</li>';
							$i++;
							}
						} else {
							echo '<li class="widget ui-draggable"><div class="widget-top sort hndle" style="cursor:move; height:30px;margin-bottom:2px;"><span style="line-height:30px;margin-left:10px;">|||</span><a class="repeatable-remove button" style="float:right;margin-top:3px;margin-right:10px;" href="#">Remove</a></div>
										<div style="padding:10px;">
											<span class="custom_default_image" style="display:none"></span>
											<input name="'.$field['id'].'[]" type="hidden" class="custom_upload_image" value="" />
													<img src="" class="custom_preview_image" alt="" /><br />
														<input class="custom_upload_image_button button" type="button" value="Choose Image" />
														<small>&nbsp;<a href="#" class="custom_clear_image_button">Remove Image</a></small>
														<br clear="all" /><br>
														Partner URL<br>
														<input class="widefat" style="width:80%" name="'.$field['id'].'_link[]" value="#">
											
										</div>
									</li>';
						}
						echo '</ul></td>
							<td><span class="description">'.$field['desc'].'</span></td>';
					break;

					case 'home_list':
						//list of used home teasers
						$teaser_list_used="";
						$alterego_home_teasers = $meta;
						
						if(is_array($alterego_home_teasers))
							foreach ($alterego_home_teasers as $teaser) {
									$teaser_list_used .= '<li class="widget ui-draggable"><input name="alterego_home_teasers[]" id="'.$teaser.'" type="hidden" value="'.$teaser.'">'.$teaser.'</li>
									';
							}

						//list of unused teasers
						$teaser_list_unused="";
						
						if(!is_array($alterego_home_teasers) || !in_array("Content", $alterego_home_teasers))	
							$teaser_list_unused .=  '<li id="alterego_home_content" class="widget ui-draggable"><input name="alterego_home_teasers[]" type="hidden" value="Content" id="Content" disabled>Content</li>';
						if(!is_array($alterego_home_teasers) ||!in_array("Teasers", $alterego_home_teasers))	
							$teaser_list_unused .= '<li id="alterego_home_teaser_project" class="widget ui-draggable"><input name="alterego_home_teasers[]" type="hidden" value="Teasers" id="Teasers" disabled>Teasers</li>';
						if(!is_array($alterego_home_teasers) ||!in_array("Partners", $alterego_home_teasers))	
							$teaser_list_unused .= '<li id="alterego_home_partners_project" class="widget ui-draggable"><input name="alterego_home_teasers[]" type="hidden" value="Partners" id="Partners" disabled>Partners</li>';
						
						if(!is_array($alterego_home_teasers) ||!in_array("Taglines", $alterego_home_teasers))	
							$teaser_list_unused .= '<li id="alterego_home_taglines" class="widget ui-draggable"><input name="alterego_home_teasers[]" type="hidden" value="Taglines" id="Taglines" disabled>Taglines</li>';	
						
						echo '<style>
						#used, #unused { list-style-type: none; margin: 0; padding: 0; float: left; background-color: #FCFCFC; border: 1px solid #DFDFDF; margin-right: 10px;  padding: 5px; width: 100%; min-height:45px;}
						#used li, #unused li { margin: 5px; padding: 5px; width: 80%; cursor:move; color: #21759B}
						#used li:hover, #unused li:hover { color: #d54e21}
						.form-table td { min-width: 250px;}
						</style>
						<script>
						jQuery(function() {
							jQuery( "#used" ).sortable({
								connectWith: "ul",
								receive: function(event, ui){
									$this = ui.item;
									$this = $this.find("input");
									$this.removeAttr("disabled");
									if($this.attr("id")=="Teasers"){
										jQuery("#page-teaser-options").slideDown();
                    					jQuery("#teaser_link").slideDown();
									}
									if($this.attr("id")=="Taglines"){
										jQuery("#page-taglines-options").slideDown();
                    					jQuery("#taglines_link").slideDown();
									}
									if($this.attr("id")=="Partners"){
										jQuery("#page-partners-options").slideDown();
                    					jQuery("#partners_link").slideDown();
									}
								}
							});
							
							jQuery( "#unused" ).sortable({
								connectWith: "ul",
								receive: function(event, ui){
									$this = ui.item;
									$this = $this.find("input");
									$this.attr("disabled",true);
									if($this.attr("id")=="Teasers"){
										jQuery("#page-teaser-options").slideUp();
                    					jQuery("#teaser_link").slideUp();
									}
									if($this.attr("id")=="Taglines"){
										jQuery("#page-taglines-options").slideUp();
                    					jQuery("#taglines_link").slideUp();
									}
									if($this.attr("id")=="Partners"){
										jQuery("#page-partners-options").slideUp();
                    					jQuery("#partners_link").slideUp();
									}
								}
							});

							jQuery( "#used, #unused" ).disableSelection();
						});
						</script>

					
						<td valign="top">
						<div style="float:left;width:40%">
							In Use<br>
							<ul id="used">
								'.$teaser_list_used.'
							</ul>
							<div style="clear:both"></div>
							</div>
						<div style="margin-left: 10%;float:left;width:40%">
							
							Available<br>
							<ul id="unused">
								'.$teaser_list_unused.'
							</ul>
							<div style="clear:both"></div>
						</div>
						</td><td><span class="description">'.$field['desc'].'</span></td></tr>
						';

					break;
					case 'category_list':
						echo '<td><select name="'.$field['id'].'" id="'.$field['id'].'"><option value="" $checked>All</option>';
                		$categories = get_categories();
						foreach ($categories as $cat) {
								$checked="";
	                		 	if($cat->slug==$meta) $checked="selected";
	                		 	echo "<option value='$cat->slug' $checked>".$cat->cat_name."</option>";
						}
                		echo '</select>';
                	break;
				} //end switch
		echo '</tr>';
	} // end foreach
	echo '<tr><td colspan=3 align="right"><input name="save" type="button" class="button-primary tp_publish_buttons" id="mypublish" accesskey="p" value=""></td></tr>';
	echo '</table>'; // end table
}

function remove_taxonomy_boxes() {
	remove_meta_box('categorydiv', 'post', 'side');
}
//add_action( 'admin_menu' , 'remove_taxonomy_boxes' );

// Save the Data
function save_custom_meta($post_id) {
    global 	$custom_meta_fields,
    		$custom_post_portfolio_type_meta_fields,
    		$custom_page_portfolio_meta_fields,
    		$custom_page_basic_meta_fields,
    		$custom_page_head_meta_fields,
    		$custom_page_elements_meta_fields,
    		$custom_page_sidebar_meta_fields,
    		$custom_page_teaser_meta_fields,
    		$custom_page_background_meta_fields,
    		$custom_post_meta_fields,
    		$custom_page_partner_meta_fields,
    		$custom_portfolio_meta_fields,
    		$custom_post_basic_meta_fields,
			$custom_post_head_meta_fields,
    		$custom_post_sidebar_meta_fields,
    		$custom_post_background_meta_fields,
    		$custom_post_type_meta_fields,
    		$custom_portfolio_basic_meta_fields,
			$custom_portfolio_head_meta_fields,
    		$custom_portfolio_sidebar_meta_fields,
    		$custom_portfolio_background_meta_fields,
    		$custom_portfolio_type_meta_fields;

    if(isset($_POST['post_type'])){
	    // which fields to use
	    if ('page' == $_POST['post_type']) {
			$custom_meta_fields = array_merge($custom_page_basic_meta_fields,
				$custom_page_head_meta_fields,
	    		$custom_page_sidebar_meta_fields,
	    		$custom_page_elements_meta_fields,
	    		$custom_page_teaser_meta_fields,
	    		$custom_page_background_meta_fields,
	    		$custom_page_portfolio_meta_fields,
	    		$custom_page_partner_meta_fields
    		);
		}
		if ('post' == $_POST['post_type']) {
			$custom_meta_fields = array_merge($custom_post_basic_meta_fields,
				$custom_post_head_meta_fields,
	    		$custom_post_sidebar_meta_fields,
	    		$custom_post_background_meta_fields,
	    		$custom_post_type_meta_fields);
		}

		$portfolio_slugs = get_option("alterego_portfolio_slug");
		if(is_array($portfolio_slugs)){
			if (in_array($_POST['post_type'], $portfolio_slugs)) {
				$custom_meta_fields = array_merge($custom_portfolio_basic_meta_fields,
			$custom_portfolio_head_meta_fields,
    		$custom_portfolio_sidebar_meta_fields,
    		$custom_portfolio_background_meta_fields,
    		$custom_portfolio_type_meta_fields);
			}
		}

		// verify nonce
		if(isset($_POST['custom_meta_box_nonce'])){
			if (!wp_verify_nonce($_POST['custom_meta_box_nonce'], basename(__FILE__))) 
				return $post_id;
		}
		// check autosave
		if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
			return $post_id;
		// check permissions
		if ('page' == $_POST['post_type']) {
			if (!current_user_can('edit_page', $post_id))
				return $post_id;
			} elseif (!current_user_can('edit_post', $post_id)) {
				return $post_id;
		}

		// loop through fields and save the data
		foreach ($custom_meta_fields as $field) {
			//if($field['type'] == 'tax_select') continue;

				$old = get_post_meta($post_id, $field['id'], true);
				
				if(isset($_POST[$field['id']]))
					$new = $_POST[$field['id']];
				else $new = "";

				//echo $field['id']."->".$new."<br> ";
			
			if ($new && $new != $old) {
				update_post_meta($post_id, $field['id'], $new);
			} elseif ('' == $new && $old) {
				delete_post_meta($post_id, $field['id'], $old);
			}


		} // end foreach
		
		// save taxonomies
		//$post = get_post($post_id);
		//$category = $_POST['category'];
		//wp_set_object_terms( $post_id, $category, 'category' );
	}
}
add_action('save_post', 'save_custom_meta');


?>